package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.PMDeletedMessage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing PMDeletedMessage in entity cache.
 *
 * @author caret
 * @see PMDeletedMessage
 * @generated
 */
public class PMDeletedMessageCacheModel implements CacheModel<PMDeletedMessage>,
    Externalizable {
    public long deletedMessageId;
    public long messageId;
    public long ownerId;
    public long deletedDate;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{deletedMessageId=");
        sb.append(deletedMessageId);
        sb.append(", messageId=");
        sb.append(messageId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", deletedDate=");
        sb.append(deletedDate);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public PMDeletedMessage toEntityModel() {
        PMDeletedMessageImpl pmDeletedMessageImpl = new PMDeletedMessageImpl();

        pmDeletedMessageImpl.setDeletedMessageId(deletedMessageId);
        pmDeletedMessageImpl.setMessageId(messageId);
        pmDeletedMessageImpl.setOwnerId(ownerId);

        if (deletedDate == Long.MIN_VALUE) {
            pmDeletedMessageImpl.setDeletedDate(null);
        } else {
            pmDeletedMessageImpl.setDeletedDate(new Date(deletedDate));
        }

        pmDeletedMessageImpl.resetOriginalValues();

        return pmDeletedMessageImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        deletedMessageId = objectInput.readLong();
        messageId = objectInput.readLong();
        ownerId = objectInput.readLong();
        deletedDate = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(deletedMessageId);
        objectOutput.writeLong(messageId);
        objectOutput.writeLong(ownerId);
        objectOutput.writeLong(deletedDate);
    }
}
